;----------========== Parsing (common to every scripts) ==========----------
; The script is being passed 2 parameters by mGalaxy.
; The first one contains the full path to the emulator.
; The second one contains parameters (optional) for the emulator PLUS the full path (between quotes) to the rom file.
;
; Line 13: $CmdLine is an array of size 3. $CmdLine[0] returns the total number of items in the array, $CmdLine[1] the 1st parameter, $CmdLine[2] the 2nd parameter
; Line 19: AutoIt requires that parameters sent by mGalaxy be enclosed in quotation marks.
;          As the parameters themselves contain quotation marks, these have been replaced by a distinguishing sign (%s) so as not to cause any confusion in the constitution of the command line.
;          So we now replace this distinguishing sign with quotation marks.
; Line 20: Some apps (MESS for instance, when it searchs for a system Bios) need to know the path to their 'Working Directory'. We do extract it from the emulator full path.
;
#include <MsgBoxConstants.au3>
If UBound($CmdLine) <> 3 Then
   MsgBox($MB_SYSTEMMODAL, "Script execution error", "The script was expecting to receive 2 parameters but received " & UBound($CmdLine)-1, 10)
   Exit 0
EndIf

local $app = $CmdLine[1]
local $command = StringReplace($CmdLine[2], "%s", """")
Local $workingDir = StringRegExpReplace($app, "\\[^\\]*$", "")
FileChangeDir($workingDir)
;---------------------------------------------------------------------------

; Open the .bat file for reading and store the handle to a variable.
Local $hFileOpen = FileOpen($command, 0)
If $hFileOpen = -1 Then
	Return False
EndIf

; Read the fist line of the file using the handle returned by FileOpen.
Local $sFileRead = FileReadLine($hFileOpen, 1)

; Close the handle returned by FileOpen.
FileClose($hFileOpen)

; Strip the application info (@daphne.exe) from .bat line
Local $count3 = StringInStr($sFileRead, '.exe', 0 , 1, 1)
local $strippedcommand = StringTrimLeft($sFileRead, $count3 + 4 )

$PID = Run ('"' & $app & '" ' & $strippedcommand)

While ProcessExists ( $PID )
   sleep(500)
WEnd

Exit 0

; reste le problme que Laserdisc accepte d'autres fichiers que .bat (.txt et .zip)...qui sont trouvs (de manire rcursive) dans le dossier Daphn o se trouvent les .bat
; faudrait-il dornavant faire passer les extensions ecceptes au niveau de l'mulateur et plus du systme! Je pense que ce serait une bonne chose!

